import maya.cmds as cmds

maya_version = int(cmds.about(version=True))

if maya_version >= 2025:
    from PySide6 import QtWidgets, QtCore, QtGui
    from shiboken6 import wrapInstance
    def toQtObject(ptr):                                 
        return wrapInstance(int(ptr), QtWidgets.QWidget)
else:
    from PySide2 import QtWidgets, QtCore, QtGui
    from shiboken2 import wrapInstance
    def toQtObject(ptr):                             
        return wrapInstance(int(ptr), QtWidgets.QWidget) 